/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Macroscript Library for Autodesk Civil View                                            --***
***--  � Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/

macroscript MCR12dImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_12DIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 3
)
macroscript MCRbuildingObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_BUILDINGOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenBuildingObjectsPanel()
)
macroscript MCRc3dImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_C3DIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenC3dImportPanel()
)
macroscript MCRchainageText category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_CHAINAGETEXT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenChainageTextTool()
)
macroscript MCRgifChecker category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GIFCHECKER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenGifCheckerTool()
)

macroScript MCRcreateSunPositioner category:~MACRO_CIVILVIEW_CATEGORY~ ButtonText:~MACRO_CREATESUNPOSITIONER_TOOLTIP~ tooltip:~MACRO_CREATESUNPOSITIONER_TOOLTIP~ icon:#("Systems",2)
(
  on execute do
  (
    --- We Need Command Panel to be open whilst doing this
    if not cui.commandPanelOpen then
    (
      local LOCtext = ~MACRO_CREATESUNPOSITIONER_QUERY01~
      LOCtext += "\n\n"
      LOCtext += ~MACRO_CREATESUNPOSITIONER_QUERY02~
      LOCtext += "\n\n"
      LOCtext += ~MACRO_CREATESUNPOSITIONER_QUERY03~
      local LOCanswer = QueryBox LOCtext title:~MACRO_CREATESUNPOSITIONER_TITLEBAR~ beep:false
      if LOCanswer then cui.commandPanelOpen = true
    )

    local LOCnodes = StartObjectCreation Sun_Positioner returnNewNodes:true
  )
  on isChecked return mcrUtils.IsCreating Sun_Positioner
)
macroscript MCRdrapeSpline category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DRAPESPLINE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDrapeSplineTool()
)
macroscript MCRdsimBearing category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMBEARING_TOOLTIP~ silenterrors:true
(
  DYNFUNpickVPbearing()
)
macroscript MCRdsimImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimImportPanel()
)
macroscript MCRdsimSubstitute category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMSUBSTITUTE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimSubstitutePanel()
)
macroscript MCRdsimSurface category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMSURFACE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimSurfacePanel()
)
macroscript MCRdxfImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DXFIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDxfImportPanel()
)
macroscript MCRexplorer category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_EXPLORER_TOOLTIP~ silenterrors:true
(
  if DYNmainFloater == undefined then DYNFUNopenExplorer()
)
macroscript MCRfeatureInterp category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_FEATUREINTERP_TOOLTIP~ silenterrors:true
(
  DYNFUNopenFeatureInterpPanel()
)
macroscript MCRgenioImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GENIOIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 1
)
macroscript MCRgRailObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GRAILOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopengRailObjectsPanel()
)
macroscript MCRimportMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_IMPORTMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenImportManDialog()
)
macroscript MCRlandXMLimport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_LANDXMLIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 4
)
macroscript MCRmakeForest category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_MAKEFOREST_TOOLTIP~ silenterrors:true
(
  DYNFUNmakeForest()
)
macroscript MCRmxImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_MXIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 2
)
macroscript MCRobjectPlacer category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OBJECTPLACER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenObjectPlacerPanel()
)
macroscript MCRopenHelp category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OPENHELP_TOOLTIP~ silenterrors:true
(
  DYNFUNopenHelp 13201 -- id_cv_civil_view_welcome 
)
macroscript MCRopenTutorials category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OPENTUTORIALS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenTutorials 13223 -- id_cv_tutorials
)
macroscript MCRplacedMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PLACEDMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPlacedManDialog()
)
macroscript MCRPointBasedPlace category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_POINTBASEDPLACE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenpointBasedPlaceTool()
)
macroscript MCRpreferences category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PREFERENCES_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPreferencesPanel 1
)
macroscript MCRproperties category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PROPERTIES_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPropertiesPanel()
)
macroscript MCRqparImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_QPARIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenQparImportPanel()
)
macroscript MCRresourceMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_RESOURCEMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenResourceManager 4 ""
)
macroscript MCRroadMarkings category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_ROADMARKINGS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenRoadMarkingsPanel()
)
macroscript MCRsightTool category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SIGHTTOOL_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSightToolPanel()
)
macroscript MCRsplineMapper category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SPLINEMAPPER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSplineMapperTool()
)
macroscript MCRsweptObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SWEPTOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSweptObjectsPanel()
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCUngPvywDVk9FIXvdAa2e1flpNb7xjzrwU
-- /xCVrGSog/y/23LeRQELSA0OMAjyLFrMi7A4Xy+6c0Oj+as85c3zk7cOFKB0iSOh
-- qjktga0fImTAAj47Ji/ii3MaOFilY/y+oHsp5utnHwF/SP3cN2LPx6qj9fBLjG1l
-- a9jz5w4zat5wHjyJbqZuoV9y/e0+MCfNUsObP+tIs3W3CXPJnKs/DXmQbAfVYLnh
-- gnDT6oVTDni4JG/5XR/JWmZfU3hSTEKu26TnQuGMjXE2+StVZdMxDlsvm0JiHQh7
-- auLF/CP1o7ExHVbmXvjQ5NuCVJcEv1AkHVJq7I/ytVb1hIXMTA6w
-- -----END-SIGNATURE-----